from enum import Enum


class PlayerOrder(Enum):
    """Enum class for int representation of Players based on turnorder."""
    PLAYER1 = 1
    PLAYER2 = 0
    NOPLAYER = -1

    def __int__(self):
        return self.value

class LearnStrat(Enum):
    """Enums for learning strategies used for AIComp objects.
    REWARD - Rewarding winning moves.
    PUNISH - Punishing losing moves.
    BOTH - Combination of both strategies."""
    REWARD = 0
    PUNISH = 1
    BOTH = 2

    def __int__(self):
        return self.value
