# Play the 'Shreksapawn' game

# Game written by Berenike Blaser

# Comments added by Georg Veh

# Import the required modules and classes for the game.

from src.shreksapawn_module_BG_GV import *
import time

# We create an instance of the Strategy class, representing the 
# system's strategy for making moves in the game.

s = Strategy()

# The User class, representing the user playing the game.

u = User()

# The Counter class keeps track of game statistics.

counter = Counter()

# The game prompts the user to enter their name and sets it as the user's name.

u.putName()

# A few print messages to welcome the player.

print()
print("Hello " + u.name + "! Your pieces are 'o'. You make the first move.")
print()
time.sleep(3)

# Repeat the game for a maximum of 100 rounds. This limit ensures that the game
# doesn't go on indefinitely.

for j in range(100):

    # We set up a new game s by creating instances of UserPiece and SystemPiece 
    # classes and initializing a Board instance with these pieces.

    u1 = UserPiece("C",0)
    u2 = UserPiece("C",1)
    u3 = UserPiece("C",2)
    s1 = SystemPiece("A",0)
    s2 = SystemPiece("A",1)
    s3 = SystemPiece("A",2)
    b = Board([u1,u2,u3,s1,s2,s3])

    # Display the current state of the game board.

    b.showBoard()
    move_to_be_removed = [0,0]

    # The following block of code is the game loop where the user and system 
    # take turns making moves until the game ends:

    for i in range(8):
        u.makeMove(b) # allows the user to make a move by interacting with the console.
        b.showBoard() # displays the updated game board after the user's move

        if b.endGame(): #  checks if the game has ended. If so:
            counter.displayWhoWon("u", u) # Display the winner and updates game statistics.
            s.removeLosingMove(last_system_move[0],last_system_move[1])
            break

        last_system_move = s.makeMove(b)
        b.showBoard()

        if b.endGame():
            counter.displayWhoWon("s", u)
            break

    counter.displayCount(u)
    print()

    # The user is prompted whether they want to play again or not. 
    # The response is validated, and based on the input, the loop 
    # continues to the next round or breaks out of the loop.

    while True:
        play_again = input("Do you want to play again? 0-yes  1-no ")
        if play_again.isdigit() and int(play_again) in range(2):
            play_again = int(play_again)
            break
        else:
            print()
            print("Please answer with one of the given options (e.g. type '0').")
            print()
    print()
    if play_again == 1:
        print("Thank you for playing!")
        break
