from typing import Iterable

import src.coordinate_functions as util
from src.player import Player
from src.board import Board
from src.movement import Movement


def terminate_game():
    """Print method for too many wrong inputs and the application gets terminated.
    """
    print("Too many wrong inputs. Game is terminated!")
    exit()

def request_selection(options: dict[int:str]) -> int:
    while True:
        for k, v in options:
            print(f"{k} - {v}")

        user_input = input("\nPlease choose one of the number options above: ")

        if util.valid_int_input(user_input, list(options)): return int(user_input)

def start_settings() -> tuple[int, int]:
    """TUI function when starting the game and requesting the parameters board size and AI strength.

    Returns:
        tuple[int, int]: board_size, ai_strength
    """

    range_board = (3,9)
    range_ai = (1,5)

    prompt_start = "Welcome to your Hexapawn experience!\n" \
        + "Please give me me some information about your preferred settings:"
    prompt_board = "How large should the board? " \
        + f"Please give one number which is used for length and width between {range_board[0]}-{range_board[1]-1}:\n"
    prompt_ai_strength = f"How strong should the ai be? consider a number between {range_ai[0]}-{range_ai[1]-1}." \
        + "\nWARNING: This number influenzes AI training exponantially!\n"


    print(prompt_start)
    while True:
        board_size = input(prompt_board)
        ai_strength = input(prompt_ai_strength)

        if (util.valid_int_input(board_size, [num for num in range(range_board[0], range_board[1])])
            and util.valid_int_input(ai_strength, [num for num in range(range_ai[0], range_ai[1])])):
            return int(board_size), int(ai_strength)
        else:
            print("Your input was not valid. Please use only number within range!")

def ask_repeat() -> bool:
    """Asks user iíf it wants to play another round.

    Returns:
        bool: If user wants to keep playing or not
    """
    while True:
        user_input = input("Play another round? (Y/N): ")

        if user_input.lower() == "y": return True
        elif user_input.lower() == "n": return False
        else: print("No valid input...")

def print_gamestate(active_player: Player, turn: int,
                        move: Movement, board: Board):
    """Prints the current gamestate.

    Args:
        active_player (Player): Payer that was making the turn
        turn (int): Turn number
        move (Movement): move performed
        board (Board): board after the move was performed
    """
    print(f"Player: {active_player} | Turn: {turn}")
    print("\t", move)
    print(board)

def print_startstate(player_one: Player, player_two: Player, board: Board):
    """Print function to show the players and their according colors.
    Colors are hardcoded in the same way as the Pieces are.

    Args:
        player_one (Player): First player to go
        player_two (Player): Second player to go
        board (Board): baord state. Should always be the inital board.
    """
    prompt = f"\n\033[32m{player_one}\033[0m - \033[31m{player_two}\033[0m\n" \
        + f"{board}\n"
    print(prompt)

def print_turn(active_player: int, turn: int, appli_moves: Iterable[Movement],
                move: Movement, board: Board):
    """Prints complete information of a turn.
    works similar to 'print_gamestate' but also includes all possible moves.
    Primarily used for debugging.

    Args:
        active_player (Player): Payer that was making the turn
        appli_moves (Iterable[Movement]): All moves the player had to choose from. Can also accept the changed information of 'AIComp'.
        turn (int): Turn number
        move (Movement): move performed
        board (Board): board after the move was performed
    """
    print(f"Player: {active_player} | Turn: {turn}")
    print(appli_moves)
    print("\t", move)
    print(board)
