# %%
# farben terminal
# to use colors in terminal printing you need to use the appropraite strings
# a list of them can be found here: https://gist.github.com/minism/1590432
# remember that the codes are based on your OS, thus the codes are different for windows, mac etc.


# Lets use this stuff within a class and let magic happen

class colors:
    RED   = "\033[1;31m"
    BLUE  = "\033[1;34m"
    CYAN  = "\033[1;36m"
    GREEN = "\033[0;32m"
    RESET = "\033[0;0m"
    BOLD    = "\033[;1m"
    REVERSE = "\033[;7m"

# play around and get a feeling for them, they are pretty straight forward
# there are also ready to use librarys like 'termcolor' or 'colored' and way ore... find one you like or use the codes themself

# %%
# f-strings are neat way to write strings
# they are basically functional strings, meaning they support variables, calculations and even code
# all variables, calculations and so on and so forth must be enclosed curly braces '{}'
# look at the examples below and play withem to get an intuitiv understanding

print(f"HI")

x = "HI but cooler"
print(f"{x}")

num1 = 1
num2 = 2

print(f"{num1} + {num2} = {num1 + num2}")

print(f"{1 < 2}")

print(f"{True == False}")

# they support formating as well.
# without going into detail here, there is one example which could give you some quality of life

for i in range(10):
    print(f"{i**2=}")

# the equal sign simply alters your output to print the original statement as well as the according result
# a really simple way to prevent confusion when a lot of prints are used


# %%
# Enums are a smart way to give values you are using meaning
# they allow persons, that are working wiht your code to understand your intentions behind some random numbers

# look at the example below without enums

class Delivery:

    def __init__(self):
        self.state = 0

    def is_deliverable(self):
        if self.state == 3: return True
        else: return False

# it's hard to understand what the intention of the integers really is
# now lets use some enums for this class

class DeliveryState:
    ORDERED = 0
    PREPAIRED = 1
    DELIVERING = 2
    DELIVERED = 3

class Delivery:

    def __init__(self):
        self.state = DeliveryState.ORDERED

    def is_delivered(self):
        if self.state == DeliveryState.DELIVERED: return True
        else: return False

# The code itself didn't changed but it is easier to understand what exactly is meant within the lines of code
# now there is some code to understand enums and how they work

class EnumEX:
    STATE1 = 1
    STATE2 = 2
    STATE3 = 3

print(EnumEX.STATE1)
print(EnumEX.STATE1 == 1)
print(EnumEX.STATE1 == EnumEX.STATE1)

# %%
# @property + setter + getter

# Properties are used to define attributes. They do do allow a more precise defintion of attributes.

class Test:

    def __init__(self):
        self.x = 1

class TestProperty:

    def __init__(self):
        self._x = 2

    @property
    def x(self):
        return self._x

t1 = Test()
t2 = TestProperty()

print(t1.x)
print(t2.x)

# When a property is defined this way, it can not altered

t1.x = 3
t2.x = 4 # THIS WILL PRODUCE AN AttributeError!

print(t1.x)
print(t2.x)

# %%
