from unittest import TestCase
import numpy as np

from src.piece import Pawn
from src.board import Board

class TestPawn(TestCase):

    def test_pawn_movement_possible(self):
        pawn_list = [Pawn(1,i,1) for i in range(3)]

        board_empty = np.array(((0,Pawn(0,1,1),0),(0,0,0),(0,0,0)))
        board_with_capture = np.array(((0,Pawn(0,1,1),0),(Pawn(1,1,2),0,Pawn(1,1,2)),(0,0,0)))
        board_blocked = np.array(((0,Pawn(0,1,1),0),(0,Pawn(1,1,1),0),(0,0,0)))
        board_not_capture_alli = np.array(((0,Pawn(0,1,1),0),pawn_list,(0,0,0)))

        self.assertEqual(board_empty[0,1].get_all_moves(2, board_empty).__repr__(),
                         "[B0-B1]")

        self.assertEqual(board_with_capture[0,1].get_all_moves(2, board_with_capture).__repr__(),
                         "[B0-B1, B0-C1, B0-A1]")

        self.assertEqual(board_blocked[0,1].get_all_moves(2, board_blocked).__repr__(),
                         "[]")

        self.assertEqual(board_not_capture_alli[0,1].get_all_moves(2, board_not_capture_alli).__repr__(),
                         "[]")


class TestBoard(TestCase):

    def setUp(self):
        self.board = Board(Pawn)

    def test_initial_board(self):
        self.assertEqual(self.board.get_id(), "00P101P102P110X011X012X020P021P022P0")

    def test_allowed_moves(self):
        self.assertEqual(
            [str(element) for element in self.board.legal_moves],
            ["A0-A1", "B0-B1", "C0-C1"]
            )
