from src.game import Game, train_ai
from src.board import Board
from src.piece import Pawn
from src.player import PlayerHuman, RandomComp, AIComp
import src.tui as tui
from src.enums import LearnStrat

def main():

    BOARD_SIZE, AI_STRENGTH = tui.start_settings()

    print("Training AI, please wait.\nIf this takes long, AI will be better ;)")

    player_one = PlayerHuman(first = True, name = "You")
    player_two = AIComp(first = False, name = "AI",
                            strategy = LearnStrat.PUNISH)

    board = Board(Pawn, BOARD_SIZE)

    train_ai(10**AI_STRENGTH, board, player_two, RandomComp(first = True, name = "Rando"))

    print("AI trained. Let's begin the game. :-)\n\n")

    game = Game(player_one = player_one, player_two = player_two,
        board = board)

    while True:
        game.game()
        print(f"\n{str(game.scoreboard)[1:-1]}\n")
        if not tui.ask_repeat(): break


if __name__ == '__main__':
    main()
